/*
 * Decompiled with CFR 0.152.
 */
package com.agricraft.agricraft.common.item;

import com.agricraft.agricraft.api.AgriApi;
import com.agricraft.agricraft.api.crop.AgriCrop;
import com.agricraft.agricraft.api.genetic.AgriGenome;
import com.agricraft.agricraft.api.genetic.AgriGenomeProviderItem;
import com.agricraft.agricraft.api.plant.AgriPlant;
import com.agricraft.agricraft.common.block.entity.SeedAnalyzerBlockEntity;
import com.agricraft.agricraft.common.registry.ModBlocks;
import com.agricraft.agricraft.common.registry.ModItems;
import com.agricraft.agricraft.common.util.LangUtils;
import java.util.List;
import java.util.Optional;
import net.minecraft.class_1269;
import net.minecraft.class_1309;
import net.minecraft.class_1657;
import net.minecraft.class_1747;
import net.minecraft.class_1750;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1836;
import net.minecraft.class_1838;
import net.minecraft.class_1922;
import net.minecraft.class_1935;
import net.minecraft.class_1937;
import net.minecraft.class_2248;
import net.minecraft.class_2487;
import net.minecraft.class_2561;
import net.minecraft.class_2586;
import org.jetbrains.annotations.Nullable;

public class AgriSeedItem
extends class_1747
implements AgriGenomeProviderItem {
    public AgriSeedItem(class_1792.class_1793 properties) {
        super((class_2248)ModBlocks.CROP.get(), properties);
    }

    public static class_1799 toStack(AgriPlant plant) {
        class_1799 stack = new class_1799((class_1935)ModItems.SEED.get(), 1);
        AgriGenome genome = new AgriGenome(plant);
        class_2487 tag = new class_2487();
        genome.writeToNBT(tag);
        stack.method_7980(tag);
        return stack;
    }

    public static class_1799 toStack(AgriGenome genome) {
        class_1799 stack = new class_1799((class_1935)ModItems.SEED.get(), 1);
        class_2487 tag = new class_2487();
        genome.writeToNBT(tag);
        stack.method_7980(tag);
        return stack;
    }

    public static String getSpecies(class_1799 stack) {
        if (stack.method_7909() != ModItems.SEED.get()) {
            return "agricraft:unknown";
        }
        class_2487 tag = stack.method_7969();
        if (tag == null) {
            return "agricraft:unknown";
        }
        AgriGenome genome = AgriGenome.fromNBT(tag);
        if (genome == null) {
            return "agricraft:unknown";
        }
        return genome.getSpeciesGene().getDominant().trait();
    }

    public class_2561 method_7864(class_1799 stack) {
        if (stack.method_7969() == null) {
            return class_2561.method_43471((String)"seed.agricraft.agricraft.unknown");
        }
        AgriGenome genome = AgriGenome.fromNBT(stack.method_7969());
        if (genome == null) {
            return class_2561.method_43471((String)"seed.agricraft.agricraft.unknown");
        }
        return LangUtils.seedName(genome.getSpeciesGene().getDominant().trait());
    }

    public class_1269 method_7712(class_1750 context) {
        class_1269 result = super.method_7712(context);
        class_1937 level = context.method_8045();
        if (result.method_23665() && !level.field_9236) {
            AgriApi.getCrop((class_1922)level, context.method_8037()).ifPresent(crop -> {
                class_2487 tag = context.method_8041().method_7969();
                if (tag != null) {
                    crop.plantGenome(AgriGenome.fromNBT(tag));
                }
            });
        }
        return result;
    }

    public class_1269 method_7884(class_1838 context) {
        class_1937 level = context.method_8045();
        if (level.field_9236) {
            return class_1269.field_5811;
        }
        class_1799 heldItem = context.method_8041();
        Optional<AgriCrop> optionalAgriCrop = AgriApi.getCrop((class_1922)level, context.method_8037());
        if (optionalAgriCrop.isPresent()) {
            AgriCrop crop = optionalAgriCrop.get();
            if (crop.hasPlant() || crop.isCrossCropSticks()) {
                return class_1269.field_5811;
            }
            this.plantSeed(context.method_8036(), crop, heldItem);
            return class_1269.field_21466;
        }
        class_2586 class_25862 = level.method_8321(context.method_8037());
        if (class_25862 instanceof SeedAnalyzerBlockEntity) {
            SeedAnalyzerBlockEntity seedAnalyzer = (SeedAnalyzerBlockEntity)class_25862;
            if (seedAnalyzer.hasSeed()) {
                return class_1269.field_5811;
            }
            class_1799 remaining = seedAnalyzer.insertSeed(heldItem);
            heldItem.method_7939(remaining.method_7947());
            return class_1269.field_21466;
        }
        return AgriApi.getSoil(level, context.method_8037()).map(soil -> AgriApi.getCrop((class_1922)level, context.method_8037().method_10084()).map(crop -> {
            if (crop.hasPlant() || crop.isCrossCropSticks()) {
                return class_1269.field_5811;
            }
            this.plantSeed(context.method_8036(), (AgriCrop)crop, heldItem);
            return class_1269.field_21466;
        }).orElse(class_1269.field_5811)).orElse(super.method_7884(context));
    }

    private void plantSeed(class_1657 player, AgriCrop crop, class_1799 seed) {
        crop.plantGenome(AgriGenome.fromNBT(seed.method_7969()), (class_1309)player);
        if (player != null && !player.method_7337()) {
            seed.method_7934(1);
        }
    }

    public void method_7851(class_1799 stack, @Nullable class_1937 level, List<class_2561> tooltipComponents, class_1836 isAdvanced) {
        AgriGenome genome;
        class_2487 tag = stack.method_7969();
        if (tag != null && (genome = AgriGenome.fromNBT(tag)) != null) {
            genome.appendHoverText(tooltipComponents, isAdvanced);
        }
    }
}

